package com.bxm.thirdparty.platform.adapter.electric;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.ElectricRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 支付动作执行分发类
 *
 * @author liujia
 */
@Slf4j
@Component
public class IElectricActionDispatcher<T extends BaseRequest,O> {

    /**
     * 执行器映射MAP
     * key：关键参数的字符串组合
     * value：执行器的实现类
     */
    private Map<String, ElectricAction<T,O>> actionMap = new HashMap<>();

    @Autowired
    public IElectricActionDispatcher(List<ElectricAction<T,O>> actionList) {

        for (ElectricAction<T,O> chargePhoneAction : actionList) {
            String key = chargePhoneAction.support().name();
            if (actionMap.containsKey(key)) {
                log.error("{}已经存在,存在重复定义", key);
            }
            actionMap.put(key, chargePhoneAction);
        }
    }

    /**
     * 执行具体的支付动作
     * 根据请求参数找到具体的执行类，进行对应的逻辑处理
     *
     * @return 如果参数异常将返回null
     */
    public Message exec(PlatformContext<T,O> context) {
        ElectricRequest request = (ElectricRequest) context.getRequest();
        log.info("发起充电费动作:{}", JSON.toJSONString(context));
        ElectricAction<T,O> action = actionMap.get(request.getChannel());
        if (null == action) {
            log.error("不存在[{}]对应的支付动作处理", context);
            return null;
        }
        return action.exec(context);
    }

}
