package com.bxm.thirdparty.platform.adapter.payment;

import cn.hutool.core.bean.BeanUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.AbstractThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentModeEnum;
import com.bxm.thirdparty.platform.adapter.payment.request.PaymentRequest;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.notify.PaymentNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.PaymentPreRequest;
import com.bxm.thirdparty.platform.facade.response.PrePaymentResponse;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author lowi
 * @date 2023/4/4 17:13
 */
@Component
public class PrePaymentPlatformAction<T extends PaymentRequest> extends AbstractThirdPartyPlatformAction<PaymentPreRequest, PaymentOrderV2Entity> {

    @Resource
    private IPaymentActionDispatcher iPaymentActionDispatcher;


    @Override
    public Message exec(PlatformContext<PaymentPreRequest, PaymentOrderV2Entity> context) {

        PaymentPreRequest request = context.getRequest();
        PaymentOrderV2Entity orderInfo = context.getOrderInfo();

        PaymentRequest paymentRequest = new PaymentRequest();

        paymentRequest.setPlatform(PlatformEnum.get(request.getPayPlatform()));
        paymentRequest.setMode(PaymentModeEnum.get(request.getPayMode()));
        paymentRequest.setAction(PaymentActionEnum.PRE_PAYMENT);
        paymentRequest.setRequestOrderNo(orderInfo.getOrderNo());

        T methodParamClass = (T) iPaymentActionDispatcher.getMethodParamClass(paymentRequest);
        methodParamClass.setPlatform(PlatformEnum.get(request.getPayPlatform()));
        methodParamClass.setMode(PaymentModeEnum.get(request.getPayMode()));
        methodParamClass.setAction(PaymentActionEnum.PRE_PAYMENT);
        methodParamClass.setRequestOrderNo(orderInfo.getOrderNo());
        BeanUtil.copyProperties(request, methodParamClass);
        return iPaymentActionDispatcher.exec(methodParamClass);
    }


    @Override
    public Class<? extends BaseRequest> support() {
        return PaymentPreRequest.class;
    }

    @Override
    protected Message mockResult(PlatformContext<PaymentPreRequest, PaymentOrderV2Entity> context) {
        PrePaymentResponse response = new PrePaymentResponse();
        PaymentOrderV2Entity orderInfo = context.getOrderInfo();
        response.setRequestId(context.getRequestId());

        PaymentNotifyResponse notifyResponse = new PaymentNotifyResponse();
        notifyResponse.setSuccess(true);
        notifyResponse.setOrderNo(orderInfo.getOrderNo());
        notifyResponse.setOutOrderNo(orderInfo.getOutOrderNo());
        notifyResponse.setRequestId(context.getRequestId());
        submitQueueNotify(context, JSON.toJSONString(notifyResponse));

        return Message.build().addParam(CommonConstant.RESULT_DTO, response);
    }
}
