package com.bxm.thirdparty.platform.adapter.payment.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 支付动作枚举,对应着不同的支付环节，不同的支付平台和支付模式之间会有区别
 *
 * @author liujia
 */
@Getter
@AllArgsConstructor
public enum PaymentActionEnum {

    /**
     * 在支付之前发起预付款订单
     * 前端只需要支付时触发，提交支付请求到服务端
     * 服务端组装支付请求并提交第三方进行校验
     * 如果校验通过则返回预支付信息到前端
     */
    PRE_PAYMENT("P", 0),

    /**
     * 执行支付回调处理
     * 用户在第三方完成支付后，第三方将支付结果回调给服务端
     * 服务端解析回调结果，返回支付结果给前端，同时更新支付订单状态
     */
    PAYMENT_CALLBACK("C", 1),

    /**
     * 转账到用户，一般用于用户提现
     * 获取用户的相关平台转账标识信息
     * 通过第三方API完成转账
     */
    TRANSFERS("T", 2),

    /**
     * 发起退款，从商户号原路退回
     */
    REFUND("R", 3),

    /**
     * 退款结果查询
     */
    REFUND_QUERY("RQ", 4),

    /**
     * 退款处理结果回调
     */
    REFUND_CALLBACK("RC", 5),

    /**
     * 支付结果查询
     */
    QUERY("Q", 6),
    ;

    private String prefix;

    private Integer code;

    public static PaymentActionEnum getByCode(int code) {
        for (PaymentActionEnum value : values()) {
            if (value.getCode() == code) {
                return value;
            }
        }
        return null;
    }

    public static PaymentActionEnum get(String action) {
        for (PaymentActionEnum value : values()) {
            if (value.name().equals(action)) {
                return value;
            }
        }
        return null;
    }

}
