package com.bxm.thirdparty.platform.adapter.payment.enums;

import com.bxm.thirdparty.platform.facade.enums.WithdrawErrorTypeEnum;
import lombok.Getter;

import java.util.Objects;

/**
 * 微信错误码
 *
 * @author lowi
 * @date 2023/4/19 10:57
 */
@Getter
public enum WxErrorEnum {
    /**
     *
     */
    SENDNUM_LIMIT("用户今日付款次数超过限制", WithdrawErrorTypeEnum.WITHDRAW_NUM_LIMIT),

    MONEY_LIMIT("用户单日收款限额影响", WithdrawErrorTypeEnum.WITHDRAW_AMOUNT_LIMIT),

    AMOUNT_LIMIT("商户余额不足，请联系相关人员处理。",WithdrawErrorTypeEnum.BALANCE_NOT_ENOUGH),

    NOTENOUGH("商户欠费，请联系相关人员处理。",WithdrawErrorTypeEnum.BALANCE_NOT_ENOUGH),
    ;

    private String desc;

    private WithdrawErrorTypeEnum errorTypeEnum;

    WxErrorEnum(String desc, WithdrawErrorTypeEnum errorTypeEnum) {
        this.desc = desc;
        this.errorTypeEnum = errorTypeEnum;
    }

    public static WithdrawErrorTypeEnum toErrorType(String errorCode) {
        for (WxErrorEnum value : values()) {
            if (Objects.equals(value.name(), errorCode)) {
                return value.getErrorTypeEnum();
            }
        }
        return WithdrawErrorTypeEnum.UNKNOWN_ERROR;
    }
}
