package com.bxm.thirdparty.platform.adapter.payment.request;

import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentModeEnum;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @author lowi
 * @date 2023/4/4 17:23
 */
@Data
@Slf4j
public class PaymentRequest {

    /**
     * 内部封装服务请求支付平台的订单号
     */
    private String requestOrderNo;
    /**
     * 支付动作，根据具体的
     */
    private PaymentActionEnum action;

    /**
     * 支付平台
     */
    private PlatformEnum platform;

    /**
     * 支付模式,不做强制要求，不是所有的支付动作都需要此值
     */
    private PaymentModeEnum mode = PaymentModeEnum.COMMON;

    /**
     * 验证参数是否完整
     *
     * @return false表示验证失败
     */
    public boolean verify() {
        boolean res = true;

        if (null == action) {
            log.error("具体的支付动作必须指定");
            res = false;
        }

        if (null == platform) {
            log.error("支付平台必须指定");
        }

        if (null == mode) {
            log.error("支付模式不能为空");
        }

        return res;
    }
}
