package com.bxm.thirdparty.platform.adapter.payment.withdraw.ali;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.request.AlipayFundTransUniTransferRequest;
import com.alipay.api.response.AlipayFundTransUniTransferResponse;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.withdraw.ali.param.AlipayFundTransUniTransferParam;
import com.bxm.thirdparty.platform.adapter.payment.withdraw.ali.param.AlipayFundTransUniTransferPayeeInfoParam;
import com.bxm.thirdparty.platform.adapter.payment.withdraw.ali.request.AliWithdrawRequest;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.response.WithdrawResponse;
import com.bxm.thirdparty.platform.service.PaymentAccountBalanceService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/3/27 10:06
 */
@Component
@Slf4j
public class AliWithdrawPreOrderAction extends PayPlatformAction<AliWithdrawRequest> {

    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;

    @Resource
    private PaymentAccountBalanceService paymentAccountBalanceService;


    @Override
    public Message exec(AliWithdrawRequest request) {

        AlipayClient alipayClient = paymentConfigFacadeService.getAliClientByMchId(request.getAccountId());
        if (Objects.isNull(alipayClient)) {
            return Message.build(false).setMessage("提现账户不存在");
        }

        AlipayFundTransUniTransferRequest transferRequest = new AlipayFundTransUniTransferRequest();
        // 收款人信息
        AlipayFundTransUniTransferPayeeInfoParam payeeInfoParam = new AlipayFundTransUniTransferPayeeInfoParam();
        //ALIPAY_LOGON_ID：支付宝登录号，支持邮箱和手机号格式
        payeeInfoParam.setIdentityType("ALIPAY_LOGON_ID");
        payeeInfoParam.setIdentity(request.getRealName());
        //真实姓名
        payeeInfoParam.setName(request.getRealName());

        // 转账参数
        AlipayFundTransUniTransferParam transUniTransferParam = new AlipayFundTransUniTransferParam();
        transUniTransferParam.setOutBizNo(request.getRequestOrderNo());
        transUniTransferParam.setTransAmount(request.getAmount());
        //单笔无密转账到支付宝账户固定为: TRANS_ACCOUNT_NO_PWD
        transUniTransferParam.setProductCode("TRANS_ACCOUNT_NO_PWD");
        //DIRECT_TRANSFER单笔无密转账到支付宝/银行卡, B2C现金红包
        transUniTransferParam.setBizScene("DIRECT_TRANSFER");
        transUniTransferParam.setOrderTitle(request.getTitle());
        transUniTransferParam.setPayeeInfo(payeeInfoParam);
        transUniTransferParam.setRemark(request.getRemark());
        transferRequest.setBizContent(JSON.toJSONString(transUniTransferParam));

        WithdrawResponse response = new WithdrawResponse();
        response.setRequestId(ThreadContext.getRequestId());
        response.setOutOrderNo(request.getOrderNo());
        response.setWithdrawOrderNo(request.getRequestOrderNo());
        try {
            AlipayFundTransUniTransferResponse transferResponse = alipayClient.certificateExecute(transferRequest);
            response.setSuccess(Objects.equals(transferResponse.getStatus(), "SUCCESS"));
            if (response.getSuccess()) {
                paymentAccountBalanceService.accountBalanceRemind(PlatformEnum.ALI, request.getAccountId(), request.getAmount());
            }
            response.setErrorMsg(transferResponse.getSubMsg());
            response.setResult(JSON.toJSONString(transferResponse));
        } catch (AlipayApiException e) {
            String errMsg = e.getErrMsg();
            log.error("支付宝转账处理失败，请求参数：{},message:{}", request, e.getMessage());
            response.setErrorMsg(errMsg);
            response.setSuccess(false);
        }
        return Message.build().addParam(CommonConstant.RESULT_DTO, response);
    }


    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.TRANSFERS;
    }

    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.ALI;
    }
}
