package com.bxm.thirdparty.platform.before;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 第三方平台前置操作管理
 *
 * @author lowi
 * @date 2023/3/24 14:19
 */
@Slf4j
@Component
public class BeforeThirdPartyPlatformManage<T extends BaseRequest, O> {

    private Map<Class<?>, IBeforeThirdPartyPlatformAction<T,O>> platformActionHashMap = new HashMap<>();

    public BeforeThirdPartyPlatformManage(List<IBeforeThirdPartyPlatformAction<T,O>> iThirdPartyPlatformActions) {
        for (IBeforeThirdPartyPlatformAction<T,O> iThirdPartyPlatformAction : iThirdPartyPlatformActions) {
            platformActionHashMap.put(buildKey(iThirdPartyPlatformAction), iThirdPartyPlatformAction);
        }
    }

    private Class<?> buildKey(PlatformContext context) {
        return context.getRequest().getClass();
    }

    private Class<?> buildKey(IBeforeThirdPartyPlatformAction<T,O> partyPlatformAction) {
        return partyPlatformAction.support();
    }

    public Message execBefore(PlatformContext<T, O> context) {

        IBeforeThirdPartyPlatformAction<T,O> iBeforeThirdPartyPlatformAction = platformActionHashMap.get(buildKey(context));
        if (Objects.isNull(iBeforeThirdPartyPlatformAction)) {
            return Message.build(false).setMessage("未实现的接口");
        }
        Message message = iBeforeThirdPartyPlatformAction.validationArgs(context);
        if (!message.isSuccess()) {
            return message;
        }
        iBeforeThirdPartyPlatformAction.insertInfo(context);
        return Message.build();
    }

}
