package com.bxm.thirdparty.platform.cache;

import cn.hutool.core.date.SystemClock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

import static com.bxm.thirdparty.platform.cache.PaymentAccountRedisKey.WX_WITHDRAW_QPS;

/**
 * @author lowi
 * @date 2023/5/22 20:26
 */
@Component
public class WxWithdrawLimitCache {

    @Resource
    private RedisListAdapter redisListAdapter;

    public boolean isPassQps(String accountId, Long timeValue, Integer count) {
        long timeMillis = SystemClock.now();

        Long size = redisListAdapter.size(builderKey(accountId));

        if (size < count) {
            return true;
        }
        Long first = redisListAdapter.leftPop(builderKey(accountId), Long.class);
        if ((first + timeValue) >= timeMillis) {
            return false;
        }
        return true;
    }

    private KeyGenerator builderKey(String accountId) {
        return WX_WITHDRAW_QPS.copy().appendKey(accountId);
    }


    public void addQps(String accountId) {
        long timeMillis = SystemClock.now();
        redisListAdapter.rightPush(builderKey(accountId), timeMillis);
    }
}
