package com.bxm.thirdparty.platform.callback;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.queue.QueueService;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.bo.RequestBodyBO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 第三方平台前置操作管理
 *
 * @author lowi
 * @date 2023/3/24 14:19
 */
@Slf4j
@Component
public class PlatformCallbackManage<T,O> {

    @Resource
    private QueueService queueService;

    private Map<Class<?>, IPlatformCallbackAction<T,O>> platformActionHashMap = new HashMap<>();

    public PlatformCallbackManage(List<IPlatformCallbackAction<T,O>> iThirdPartyPlatformActions) {
        for (IPlatformCallbackAction<T,O> iThirdPartyPlatformAction : iThirdPartyPlatformActions) {
            platformActionHashMap.put(buildKey(iThirdPartyPlatformAction), iThirdPartyPlatformAction);
        }
    }

    private Class<?> buildKey(PlatformCallbackContext<T,O> context) {
        return context.getCallbackParam().getClass();
    }

    private Class<?> buildKey(IPlatformCallbackAction<T,O> partyPlatformAction) {
        return partyPlatformAction.support();
    }

    public Message execCallback(PlatformCallbackContext<T,O> context) {
        IPlatformCallbackAction<T,O> iPlatformCallbackAction = platformActionHashMap.get(buildKey(context));
        if (Objects.isNull(iPlatformCallbackAction)) {
            return Message.build(false).setMessage("平台未实现的接口");
        }

        Message message = iPlatformCallbackAction.execCallback(context);
        if (!message.isSuccess()) {
            return message;
        }
        String result = null;
        Object param = message.getParam(CommonConstant.RESULT_DTO);
        if (Objects.isNull(param)) {
            log.warn("回调处理未返回有用信息，请及时处理:{}", context);
        } else {
            result = JSON.toJSONString(param);
            QueueBO queueBO = new QueueBO();
            queueBO.setApplicationName(context.getApplicationName());
            queueBO.setRequestId(context.getRequestId());
            queueBO.setRequestBodyBO(RequestBodyBO.builder()
                    .requestId(context.getRequestId())
                    .type(context.getNotifyTypeEnum().name())
                    .result(result)
                    .build());
            queueService.submitBusinessNotify(queueBO);
        }
        return Message.build();
    }

}
