package com.bxm.thirdparty.platform.callback.gongmao;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.callback.IPlatformCallbackAction;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.callback.gongmao.enums.GongMaoStatusEnum;
import com.bxm.thirdparty.platform.callback.param.GongMaoCallbackParam;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.facade.notify.ChargePhoneNotifyResponse;
import com.bxm.thirdparty.platform.facade.notify.ElectricNotifyResponse;
import com.bxm.thirdparty.platform.mapper.ChargesPhoneLogMapper;
import com.bxm.thirdparty.platform.mapper.ElectricLogMapper;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/4 16:57
 */
@Component
@Slf4j
public class GongMaoCallbackAction implements IPlatformCallbackAction {

    @Resource
    private ChargesPhoneLogMapper chargesPhoneLogMapper;

    @Resource
    private ElectricLogMapper electricLogMapper;

    @Resource
    private ThirdPartyConfigProperties thirdPartyConfigProperties;

    @Override
    public Class<?> support() {
        return GongMaoCallbackParam.class;
    }

    @Override
    public Message execCallback(PlatformCallbackContext context) {
        GongMaoCallbackParam param = (GongMaoCallbackParam) context.getCallbackParam();
        if (Objects.equals(PlatformBusinessTypeEnum.ELECTRIC.name(), param.getType())) {
            return handlerElectric(context);
        }

        if (Objects.equals(PlatformBusinessTypeEnum.CHARGE_PHONE.name(), param.getType())) {
            return handlerChargePhone(context);
        }
        return Message.build(false).setMessage("未知的类型");
    }

    private Message handlerChargePhone(PlatformCallbackContext context) {
        GongMaoCallbackParam param = (GongMaoCallbackParam) context.getCallbackParam();
        ChargesPhoneLogEntity chargesPhoneLogEntity = (ChargesPhoneLogEntity) context.getOrderInfo();

        //更新订单信息
        ChargesPhoneLogEntity updateClass = new ChargesPhoneLogEntity();
        updateClass.setStatus(param.getStatus());
        updateClass.setId(chargesPhoneLogEntity.getId());
        updateClass.setModifyTime(new Date());
        updateClass.setErrorMsg(param.getFailReason());
        chargesPhoneLogMapper.updateById(updateClass);

        //填充通知返回体
        ChargePhoneNotifyResponse response = new ChargePhoneNotifyResponse();
        response.setRequestId(context.getRequestId());
        if (Objects.equals(param.getStatus(), GongMaoStatusEnum.SUCCESS.getStatus())) {
            response.setSuccess(true);
        } else {
            response.setSuccess(false);
            response.setErrorMsg(param.getFailReason());
        }
        response.setOrderNo(chargesPhoneLogEntity.getOrderNo());
        response.setOutOrderNo(chargesPhoneLogEntity.getOutOrderNo());

        return Message.build().addParam(CommonConstant.RESULT_DTO, response);

    }

    private Message handlerElectric(PlatformCallbackContext context) {
        GongMaoCallbackParam param = (GongMaoCallbackParam) context.getCallbackParam();
        ElectricLogEntity electricLogEntity = (ElectricLogEntity) context.getOrderInfo();

        ElectricLogEntity updateClass = new ElectricLogEntity();
        updateClass.setId(electricLogEntity.getId());
        updateClass.setStatus(param.getStatus());
        updateClass.setModifyTime(new Date());
        updateClass.setErrorMsg(param.getFailReason());
        electricLogMapper.updateById(updateClass);


        //填充通知返回体
        ElectricNotifyResponse response = new ElectricNotifyResponse();
        response.setRequestId(context.getRequestId());
        if (Objects.equals(param.getStatus(), GongMaoStatusEnum.SUCCESS.getStatus())) {
            response.setSuccess(true);
            if (param.getSuccessPrice() != null) {
                BigDecimal costRate;
                if (thirdPartyConfigProperties.getSouthElectric().contains(electricLogEntity.getProvince())) {
                    costRate = thirdPartyConfigProperties.getGongMaoElectricSouthCostRate();
                } else {
                    costRate = thirdPartyConfigProperties.getGongMaoElectricCostRate();
                }
                BigDecimal molecule = param.getSuccessPrice();
                BigDecimal denominator = costRate;
                BigDecimal divide = molecule.divide(denominator, 2, RoundingMode.UP);
                response.setSuccessAmount(divide);
            }
        } else {
            response.setSuccess(false);
            response.setErrorMsg(param.getFailReason());
        }
        response.setOrderNo(electricLogEntity.getOrderNo());
        response.setOutOrderNo(electricLogEntity.getOutOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, response);
    }
}
