package com.bxm.thirdparty.platform.callback.liba;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.electric.liba.enums.LiBaStatusEnum;
import com.bxm.thirdparty.platform.callback.IPlatformCallbackAction;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.callback.param.LiBaCallbackParam;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.facade.notify.ElectricNotifyResponse;
import com.bxm.thirdparty.platform.mapper.ElectricLogMapper;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/4 16:57
 */
@Component
public class LiBaCallbackAction implements IPlatformCallbackAction {

    @Resource
    private ElectricLogMapper electricLogMapper;

    @Override
    public Class<?> support() {
        return LiBaCallbackParam.class;
    }

    @Override
    public Message execCallback(PlatformCallbackContext context) {
        LiBaCallbackParam liBaCallbackParam = (LiBaCallbackParam) context.getCallbackParam();
        ElectricLogEntity orderInfo = (ElectricLogEntity) context.getOrderInfo();

        LiBaStatusEnum liBaStatusEnum;
        if (Objects.equals(liBaCallbackParam.getStatus(), "SUCCESS")) {
            liBaStatusEnum = LiBaStatusEnum.SUCCESS;
        } else {
            liBaStatusEnum = LiBaStatusEnum.FAIL;
        }
        ElectricLogEntity updateClass = new ElectricLogEntity();
        updateClass.setId(orderInfo.getId());
        updateClass.setStatus(liBaStatusEnum.getStatus());
        updateClass.setModifyTime(new Date());
        updateClass.setThirdPartyOrderNo(liBaCallbackParam.getNumber());
        updateClass.setErrorMsg(liBaCallbackParam.getRemarks());
        electricLogMapper.updateById(updateClass);


        //填充通知返回体
        ElectricNotifyResponse response = new ElectricNotifyResponse();
        response.setRequestId(context.getRequestId());
        if (Objects.equals(liBaStatusEnum, LiBaStatusEnum.SUCCESS)) {
            response.setSuccess(true);
        } else {
            response.setSuccess(false);
            response.setErrorMsg(liBaCallbackParam.getRemarks());
        }
        response.setOrderNo(orderInfo.getOrderNo());
        response.setOutOrderNo(orderInfo.getOutOrderNo());

        return Message.build().addParam(CommonConstant.RESULT_DTO, response);
    }
}
