package com.bxm.thirdparty.platform.callback.param;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author lowi
 * @date 2023/3/29 15:47
 */
@Data
public class AlipayPaymentCallbackParam  {

    /**
     * 商户订单号。原支付请求的商户订单号。
     */
    @JsonProperty("out_trade_no")
    private String outTradeNo;

    /**
     * 支付宝交易号。支付宝交易凭证号
     */
    @JsonProperty("trade_no")
    private String tradeNo;

    /**
     * 交易状态。交易目前所处的状态
     * TRADE_SUCCESS: 交易支付成功。
     * TRADE_CLOSED: 未付款交易超时关闭，或支付完成后全额退款。
     */
    @JsonProperty("trade_status")
    private String tradeStatus;

    /**
     * 开发者的 app_id。支付宝分配给开发者的应用 ID。
     */
    @JsonProperty("app_id")
    private String appId;

    /**
     * 签名类型。签名算法类型，目前支持 RSA2 和 RSA，推荐使用 RSA2。
     */
    @JsonProperty("sign_type")
    private String signType;

    /**
     * 通知的发送时间。格式为 yyyy-MM-dd HH:mm:ss。
     */
    @JsonProperty("notify_time")
    private Date notifyTime;

    /**
     * 签名值
     */
    private String sign;

}
