package com.bxm.thirdparty.platform.callback.param;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lowi
 * @date 2022/6/21 10:44
 */
@Data
public class LiBaCallbackParam {
    /**
     * 平台 appId
     */
    private String appId;

    /**
     * 平台订单号
     */
    private String number;

    /**
     * 用户订单号
     */
    private String orderId;

    /**
     * 充值账号
     */
    private String account;

    /**
     * 充值金额
     */
    private BigDecimal amount;

    /**
     * 充值到账时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "Asia/Shanghai")
    private Date createdAt;

    /**
     * SUCCESS 充值成功
     * FAIL 充值失败
     */
    private String status;

    private String remarks;

}
