package com.bxm.thirdparty.platform.config;

import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author lowi
 * @date 2023/3/24 14:13
 */
@Data
@Component
@ConfigurationProperties("thirdparty.config")
public class ThirdPartyConfigProperties {

    private String dingdingUrl = "https://oapi.dingtalk.com/robot/send?access_token=02a47e3723b5613264a746159a2a926c1093ee69ce9af77a7dbec65275ee6b76";

    /**
     * 通知服务器模拟，测试通知其他服务mock成功
     */
    private Boolean notifyServerMocK = Boolean.FALSE;

    private String serverUrl = "";

    private String paymentAccountRecharge = "/v1/3rd/public/account/recharge";
    /**
     * 支付宝回调地址
     */
    private String aliPayCallbackUrl = "/v1/3rd/public/callback/alipay/trade";
    /**
     * 微信回调地址
     */
    private String wxPayCallbackUrl = "/v1/3rd/public/callback/wechat/trade";
    /**
     * 微信退款回调地址
     */
    private String wxRefundCallbackUrl = "/v1/3rd/public/callback/wechat/refund";
    /**
     * 心融回调地址
     */
    private String xinRongCallbackUrl = "/v1/3rd/public/callback/xinrong";
    /**
     * 力拔回调地址
     */
    private String liBaCallbackUrl = "/v1/3rd/public/callback/liba";
    /**
     * 工猫话费回调地址
     */
    private String gongMaoChargePhoneCallbackUrl = "/v1/3rd/public/callback/gongmao/chargePhone";
    /**
     * 工猫电费回调地址
     */
    private String gongMaoElectricCallbackUrl = "/v1/3rd/public/callback/gongmao/electric";

    private String defaultElectricPlatform = "LI_BA";
    /**
     * 力拔配置
     */
    private String liBaAppId = "nyvpbisq2b";

    private String liBaAppKey = "0d3eef147126cb0c45fcee64557f07b5";

    private String liBaCheckAccountApi = "http://47.94.184.147/api/amount/server";

    private String liBaCreateOrderApi = "http://47.94.184.147/api/rechargecable/server";

    /**
     * 默认充话费渠道
     */
    private String defaultChargePhoneChannel = PlatformEnum.XIN_RONG.name();

    /**
     * 默认充电费渠道
     */
    private String defaultElectricChannel = PlatformEnum.LI_BA.name();


    /**
     * 支持不同应用使用不同开户的心融话费充值
     * key:业务服务名称
     * value:心融配置
     */
    private Map<String, XinRongConfig> applicationXinRongConfig = Maps.newHashMap();

    @Data
    public static class XinRongConfig {
        private String clientId = "GoDaNquWoXQjda6Vrx44";
        private String clientSecret = "wWkKq1frq8UaaQfXd8Eq2uTPj";
        /**
         * 3.1	充值下单
         */
        private String createOrder = "http://47.118.69.121/createorder.html";
        /**
         * 3.3	账户查询
         */
        private String checkAccount = "http://47.118.69.121/createorder.html";
        private String queryOrder = "http://47.118.69.121/createorder.html";
    }

    /**
     * 工猫配置
     * test:8301bb4694174efaabc2dc7b9173f6f9
     * prod:79b354f72df14276aebf6ae9c9393364
     */
    private String gongMaoAppKey = "8301bb4694174efaabc2dc7b9173f6f9";

    /**
     * test:6b20ddaf6743edb95f2bb40861e218ed
     * prod:6c76d98cecbb3a86198afd9e231b018b
     */
    private String gongMaoAppSecret = "6b20ddaf6743edb95f2bb40861e218ed";
    /**
     * 工猫请求域名
     * 正式环境：https://openapi.gongmall.com
     * 测试环境：https://openapi-qa.gongmall.com
     */
    private String gongMaoDomain = "https://openapi-qa.gongmall.com";
    /**
     * 工猫提交订单
     */
    private String gongMaoSubmitOrderUrl = "/api/sideline/order/submitOrder";
    /**
     * 工猫订单信息
     */
    private String gongMaoOrderInfoUrl = "/api/sideline/order/getOrder";
    /**
     * 工猫余额信息
     */
    private String gongMaoBalanceUrl = "/api/sideline/agent/getBalance";

    /**
     * 工猫电费成本折扣
     */
    private BigDecimal gongMaoElectricCostRate = BigDecimal.valueOf(0.926);

    /**
     * 工猫南网电费成本折扣
     */
    private BigDecimal gongMaoElectricSouthCostRate = BigDecimal.valueOf(0.93);



    /**
     * 工猫话费字典列表
     */
    private List<GongMaoChargePhoneDict> gongMaoChargePhoneDictList = new ArrayList<>();

    /**
     * 工猫电费字典列表
     */
    private List<GongMaoElectricDict> gongMaoElectricDictList = new ArrayList<>();

    @Data
    public static class GongMaoChargePhoneDict {

        /**
         * 票面价值
         */
        private BigDecimal faceValue;

        /**
         * 产品id
         */
        private String productId;

        /**
         * 手机运营商
         */
        private String phoneCarrier;

        /**
         * 手机运营商
         */
        private String productName;
    }

    @Data
    public static class GongMaoElectricDict {

        private BigDecimal faceValue;

        private String productId;

        private String productName;
    }

    /**
     * 移动号码分段
     */
    private List<String> movePhoneParagraph = Lists.newArrayList(
            "134",
            "135",
            "136",
            "137",
            "138",
            "139",
            "147",
            "150",
            "151",
            "152",
            "157",
            "158",
            "159",
            "178",
            "182",
            "183",
            "184",
            "187",
            "188",
            "195",
            "198");


    /**
     * 联通号码分段
     */
    private List<String> umPhoneParagraph = Lists.newArrayList(
            "130",
            "131",
            "132",
            "145",
            "155",
            "156",
            "166",
            "175",
            "176",
            "185",
            "186",
            "196");


    /**
     * 电信号码分段
     */
    private List<String> tmPhoneParagraph = Lists.newArrayList(
            "133",
            "153",
            "173",
            "177",
            "180",
            "181",
            "189",
            "190",
            "191",
            "193",
            "199");


    private List<String> accountMoneyRemindStage = Lists.newArrayList(
            "1000-900",
            "900-800",
            "800-700",
            "700-600",
            "600-500",
            "500-400",
            "400-300",
            "300-200",
            "200-100",
            "100-0"
    );

    /**
     * 重试间隔数组
     * 每次失败后间隔多少秒进行重试
     */
    private int[] retryIntervalArray = {
            5,
            10,
            30,
            60,
            300,
            1500
    };

    private List<String> southElectric = Lists.newArrayList("广东省", "广西壮族自治区", "云南省", "贵州省", "海南省");

    /**
     * 帐户余额提醒
     */
    private BigDecimal accountBalanceRemind = BigDecimal.valueOf(2000);


    private Integer wxV3WithdrawQps = 50;

    private Boolean globalWithdrawEnableMock = Boolean.FALSE;
}
