package com.bxm.thirdparty.platform.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/6 14:48
 */
@Getter
public enum PaymentRefundStatusEnum {


    /**
     * 退款中
     */
    REFUND_ING(0),

    /**
     * 已退款
     */
    REFUNDED(1),

    /**
     * 退款失败
     */
    REFUND_FAIL(2),
    ;

    private int code;

    PaymentRefundStatusEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public boolean match(int code) {
        return Objects.equals(code, this.code);
    }
}
