package com.bxm.thirdparty.platform.interceptor;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.cache.WxWithdrawLimitCache;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.WithdrawRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @author lowi
 * @date 2023/5/22 19:04
 */
@Slf4j
@Component
public class WxWithdrawCurrentLimiterInterceptor implements IThirdPartyInterceptor {

    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;

    @Resource
    private ThirdPartyConfigProperties thirdPartyConfigProperties;

    @Resource
    WxWithdrawLimitCache wxWithdrawLimitCache;

    @Override
    public <T extends BaseRequest> Message accept(T t) {

        WithdrawRequest withdrawRequest = (WithdrawRequest) t;
        if (!Objects.equals(withdrawRequest.getPayPlatform(), PlatformEnum.WX.name())) {
            return Message.build();
        }
        Boolean apiV3Enable = paymentConfigFacadeService.getApiV3Enable(withdrawRequest.getAccountId());

        if (apiV3Enable) {
            long timeValue = TimeUnit.SECONDS.toMillis(1);
            boolean passQps = wxWithdrawLimitCache.isPassQps(withdrawRequest.getAccountId(), timeValue, thirdPartyConfigProperties.getWxV3WithdrawQps());
            if (!passQps) {
                log.error("qps限流了：{}", t);
                return Message.build(false).setMessage("请求过于频繁，请稍后重试");
            }
            log.info("qps通过：{}", t);
        }
        return Message.build();
    }
}
