package com.bxm.thirdparty.platform.queue;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.thirdparty.platform.cache.QueueRedisKey;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * 业务通知缓存管理
 *
 * @author lowi
 */
@Component
@AllArgsConstructor
public class NotifyQueueCacheHolder {

    private final RedisListAdapter redisListAdapter;

    public void addToQueue(QueueBO queueBO) {
        redisListAdapter.leftPush(QueueRedisKey.BUSINESS_QUEUE_INFO.copy(), queueBO);
    }

    public QueueBO pop() {
        return redisListAdapter.rightPop(QueueRedisKey.BUSINESS_QUEUE_INFO.copy(), QueueBO.class);
    }
}
