package com.bxm.thirdparty.platform.queue;

import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.notifybusiness.INotifyBusinessAction;
import com.bxm.thirdparty.platform.queue.notifybusiness.enums.QueueEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lowi
 * @date 2023/3/28 20:00
 */
@Slf4j
@Component
public class QueueManage {

    private Map<String, INotifyBusinessAction> businessActionMap;

    public QueueManage(List<INotifyBusinessAction> list) {
        businessActionMap = new HashMap<>();
        for (INotifyBusinessAction iNotifyBusinessAction : list) {
            businessActionMap.put(iNotifyBusinessAction.type(), iNotifyBusinessAction);
        }
    }

    /**
     * 通知业务方
     *
     * @param queueBO 队列博
     */
    public void notifyBusiness(QueueBO queueBO) {
        INotifyBusinessAction iNotifyBusinessAction = businessActionMap.get(QueueEnum.DEFAULT.name());
        iNotifyBusinessAction.notifyBusiness(queueBO);
    }
}
