package com.bxm.thirdparty.platform.service;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.callback.param.*;

/**
 * @author lowi
 * @date 2023/4/7 17:16
 */

public interface ThirdPartyCallbackService {

    /**
     * exec支付宝交易回调
     *
     * @param requestBody 请求体
     * @return {@link Message}
     */
    Message execAlipayTradeCallback(AlipayPaymentCallbackParam requestBody);

    /**
     * 执行微信回调
     *
     * @param wxPaymentCallbackParam wx支付回调参数
     * @return {@link Message}
     */
    Message executeWechatCallback(WxPaymentCallbackParam wxPaymentCallbackParam);

    /**
     * exec xinrong回调
     *
     * @param param 参数
     * @return {@link Message}
     */
    Message execXinrongCallback(XinRongChargePhoneParam param);

    /**
     * exec力拔回调
     *
     * @param param 参数
     * @return {@link Message}
     */
    Message execLiBaCallback(LiBaCallbackParam param);

    /**
     * exec微信退款
     *
     * @param wxRefundCallbackParam wx退款回调参数
     * @return {@link Message}
     */
    Message execWechatRefund(WxRefundCallbackParam wxRefundCallbackParam);

    /**
     * exec gongmao回调
     *
     * @param param 参数
     * @return {@link Message}
     */
    Message execGongmaoCallback(GongMaoCallbackParam param);
}
