package com.bxm.thirdparty.platform.service.impl;

import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.thirdparty.platform.cache.RelationApplicationRedisKey;
import com.bxm.thirdparty.platform.facade.request.RegisterNotifyParam;
import com.bxm.thirdparty.platform.mapper.BusinessNotifyRelationMapper;
import com.bxm.thirdparty.platform.model.entity.BusinessNotifyRelationEntity;
import com.bxm.thirdparty.platform.service.ApplicationRelationService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/3/31 16:40
 */
@Slf4j
@AllArgsConstructor
@Service
public class ApplicationRelationServiceImpl implements ApplicationRelationService {

    private final BusinessNotifyRelationMapper businessNotifyRelationMapper;

    private final RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public Boolean registerNotify(RegisterNotifyParam param) {
        BusinessNotifyRelationEntity notifyRelationEntity = businessNotifyRelationMapper.getByApplication(param.getApplicationName());
        if (Objects.isNull(notifyRelationEntity)) {
            notifyRelationEntity = new BusinessNotifyRelationEntity();
            notifyRelationEntity.setApplication(param.getApplicationName());
            notifyRelationEntity.setNotifyUrl(param.getNotifyUrl());
            notifyRelationEntity.setCreateTime(new Date());
            businessNotifyRelationMapper.insert(notifyRelationEntity);

            redisHashMapAdapter.put(RelationApplicationRedisKey.APPLICATION_NOTIFY_KEY.copy(), param.getApplicationName(), param.getNotifyUrl());
            return Boolean.TRUE;
        }

        if (!Objects.equals(param.getNotifyUrl(), notifyRelationEntity.getNotifyUrl())) {
            Integer id = notifyRelationEntity.getId();
            notifyRelationEntity = new BusinessNotifyRelationEntity();
            notifyRelationEntity.setId(id);
            notifyRelationEntity.setApplication(param.getApplicationName());
            notifyRelationEntity.setNotifyUrl(param.getNotifyUrl());
            notifyRelationEntity.setModifyTime(new Date());
            businessNotifyRelationMapper.updateById(notifyRelationEntity);

            redisHashMapAdapter.put(RelationApplicationRedisKey.APPLICATION_NOTIFY_KEY.copy(), param.getApplicationName(), param.getNotifyUrl());

        }
        return Boolean.TRUE;
    }

    @Override
    public String getNotifyUrl(String applicationName) {
        return redisHashMapAdapter.get(RelationApplicationRedisKey.APPLICATION_NOTIFY_KEY.copy(), applicationName, String.class);
    }
}
