package com.bxm.thirdparty.platform.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.facade.response.PhoneIspDTO;
import com.bxm.thirdparty.platform.mapper.PhoneAnalysisMapper;
import com.bxm.thirdparty.platform.model.entity.PhoneAnalysisEntity;
import com.bxm.thirdparty.platform.service.PhoneIspService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author lowi
 * @date 2023/5/29 9:56
 */
@Slf4j
@Service
@AllArgsConstructor
public class PhoneIspServiceImpl implements PhoneIspService {

    private final PhoneAnalysisMapper phoneAnalysisMapper;

    @Override
    public Message getPhoneIsp(String phone) {

        if (!NumberUtil.isNumber(phone) || phone.length() < 11) {
            return Message.build(false).setMessage("请输入正确的手机号");
        }

        String substring = phone.substring(0, 7);

        PhoneAnalysisEntity phoneIspInfo = phoneAnalysisMapper.getPhoneIspInfo(substring);
        if (phoneIspInfo == null) {
            return Message.build(false).setMessage("暂不支持的运营商");
        }

        PhoneIspDTO phoneIspDTO = new PhoneIspDTO();
        phoneIspDTO.setCity(phoneIspInfo.getCity());
        phoneIspDTO.setProvince(phoneIspInfo.getProvince());
        phoneIspDTO.setIsp(phoneIspInfo.getIsp());
        phoneIspDTO.setPhone(phone);
        phoneIspDTO.setSuccess(true);
        phoneIspDTO.setRequestId(ThreadContext.getRequestId());
        return Message.build(true).addParam(CommonConstant.RESULT_DTO, phoneIspDTO);
    }
}
