package com.bxm.thirdparty.platform.service.impl;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.thirdparty.platform.adapter.ThirdPartyPlatformManage;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.before.BeforeThirdPartyPlatformManage;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.facade.enums.NotifyTypeEnum;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.service.ApplicationRelationService;
import com.bxm.thirdparty.platform.service.ThirdPartyPlatformService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/6 9:57
 */
@Slf4j
@Service
@AllArgsConstructor
public class ThirdPartyPlatformServiceImpl<O> implements ThirdPartyPlatformService {

    private final ThirdPartyPlatformManage thirdPartyPlatformManage;

    private final BeforeThirdPartyPlatformManage beforeThirdPartyPlatformManage;

    private final ApplicationRelationService applicationRelationService;

    private final DistributedLock distributedLock;

    @Override
    @SuppressWarnings("unchecked")
    public <T extends BaseRequest> Message execPlatformHandler(T t) {
        int i = JSON.toJSONString(t).hashCode();
        boolean lock = distributedLock.lock(t.getApplicationName() + i);

        if (!lock) {
            log.warn("请勿重复点击：{}", t);
            return Message.build(false).setMessage("请勿重复点击");
        }

        String notifyUrl = applicationRelationService.getNotifyUrl(t.getApplicationName());
        if (Objects.isNull(notifyUrl)) {
            return Message.build(false).setMessage("业务未注册到内部封装服务");
        }
        //默认不开启mock
        if (t.getMock() == null) {
            t.setMock(false);
        }
        PlatformContext<T, O> context = new PlatformContext<>();
        context.setRequest(t);
        context.setNotifyUrl(notifyUrl);
        context.setRequestId(ThreadContext.getRequestId());

        NotifyTypeEnum notifyTypeEnum = NotifyTypeEnum.getRequestType(context.getRequest().getClass().getSimpleName());
        if (Objects.isNull(notifyTypeEnum)) {
            log.error("NotifyTypeEnum未做请求体和返回体关联");
        }
        context.setNotifyType(notifyTypeEnum);

        Message exec = beforeThirdPartyPlatformManage.execBefore(context);
        if (!exec.isSuccess()) {
            return exec;
        }

        if (Objects.equals(t.getMock(), Boolean.TRUE)) {
            log.info("业务请求为mock,延迟5s发送通知到业务方 request:{}", t);

        }
        return thirdPartyPlatformManage.execCore(context);
    }
}
