package com.bxm.thirdparty.platform.thirdpartyretry.strategy;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.ThirdPartyPlatformManage;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.facade.request.ElectricRequest;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import com.bxm.thirdparty.platform.model.entity.ThirdPartyFailLogEntity;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author lowi
 * @date 2023/4/18 13:51
 */
@Component
public class ElectricThirdPartyRetry extends AbstractThirdPartyRetry {

    @Resource
    private ThirdPartyPlatformManage thirdPartyPlatformManage;

    @Override
    protected PlatformBusinessTypeEnum typeEnum() {
        return PlatformBusinessTypeEnum.ELECTRIC;
    }

    @Override
    protected Message exec(ThirdPartyFailLogEntity thirdPartyFailLogEntity) {
        String paramDto = thirdPartyFailLogEntity.getParamDto();
        PlatformContext<ElectricRequest, ElectricLogEntity> context = JSON.parseObject(paramDto, new TypeReference<PlatformContext<ElectricRequest, ElectricLogEntity>>() {
        });
        return thirdPartyPlatformManage.execCore(context);
    }
}
