package com.bxm.thirdparty.platform.thirdpartyretry.strategy;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.model.entity.ThirdPartyFailLogEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/18 13:48
 */
@Component
@Slf4j
public class ThirdPartyRetryManage {

    private Map<String, AbstractThirdPartyRetry> map;

    public ThirdPartyRetryManage(List<AbstractThirdPartyRetry> abstractThirdPartyRetries) {
        map = new HashMap<>();
        for (AbstractThirdPartyRetry abstractThirdPartyRetry : abstractThirdPartyRetries) {
            map.put(abstractThirdPartyRetry.typeEnum().name(), abstractThirdPartyRetry);
        }
    }

    public Message execRetry(ThirdPartyFailLogEntity thirdPartyFailLogEntity) {
        AbstractThirdPartyRetry abstractThirdPartyRetry = map.get(thirdPartyFailLogEntity.getPlatform());

        if (Objects.isNull(abstractThirdPartyRetry)) {
            log.error("{}业务代码不支持", thirdPartyFailLogEntity.getPlatform());
            return Message.build(false).setMessage(thirdPartyFailLogEntity.getPlatform() + "业务不支持");
        }
        return abstractThirdPartyRetry.exec(thirdPartyFailLogEntity);
    }
}
