package com.bxm.thirdparty.platform.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.thirdparty.platform.adapter.chargephone.gongmao.bo.GongMaoBalanceBO;
import com.bxm.thirdparty.platform.adapter.chargephone.gongmao.bo.GongMaoResultBO;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import lombok.extern.slf4j.Slf4j;

import java.util.*;

/**
 * @author lowi
 * @date 2023/5/6 14:00
 */
@Slf4j
public class GongMaoUtil {

    private ThirdPartyConfigProperties thirdPartyConfigProperties;

    public GongMaoUtil(ThirdPartyConfigProperties thirdPartyConfigProperties) {
        this.thirdPartyConfigProperties = thirdPartyConfigProperties;
    }

    public String submitOrder(Map<String, Object> paramMap) {
        paramMap.put("sign", getSign(paramMap));
        HttpRequest httpRequest = HttpUtil.createPost(thirdPartyConfigProperties.getGongMaoDomain() + thirdPartyConfigProperties.getGongMaoSubmitOrderUrl());
        httpRequest.charset(CharsetUtil.CHARSET_UTF_8);
        httpRequest.form(paramMap);
        HttpResponse execute = null;
        try {
            execute = httpRequest.execute();
        } catch (Exception e) {
            log.error("工猫提交订单失败，请求体：{},error:", JSON.toJSONString(paramMap), e);
            return null;
        }
        log.info("工猫提交充值订单，请求体：{},result:{}", JSON.toJSONString(paramMap), execute.body());
        if (execute.isOk()) {
            return execute.body();
        } else {
            return null;
        }
    }

    public GongMaoBalanceBO getBalance() {
        Map<String, Object> params = new HashMap<>();
        params.put("sign", getSign(params));
        HttpRequest httpRequest = HttpUtil.createPost(thirdPartyConfigProperties.getGongMaoDomain() + thirdPartyConfigProperties.getGongMaoBalanceUrl());
        httpRequest.charset(CharsetUtil.CHARSET_UTF_8);
        httpRequest.form(params);
        HttpResponse execute = null;
        try {
            execute = httpRequest.execute();
        } catch (Exception e) {
            log.error("工猫查询余额失败，请求体：{},error:", JSON.toJSONString(params), e);
            return null;
        }
        log.info("工猫查询余额，请求体：{},result:{}", JSON.toJSONString(params), execute.body());
        if (execute.isOk()) {
            String body = execute.body();
            GongMaoResultBO gongMaoResultBO = JSON.parseObject(body, GongMaoResultBO.class);

            if (gongMaoResultBO != null && gongMaoResultBO.getSuccess()) {
                return JSON.parseObject(JSON.toJSONString(gongMaoResultBO.getData()), GongMaoBalanceBO.class);
            }
            return null;
        } else {
            return null;
        }
    }

    public String getProduct() {
        Map<String, Object> params = new HashMap<>();
        params.put("sign", getSign(params));
        HttpRequest httpRequest = HttpUtil.createPost(thirdPartyConfigProperties.getGongMaoDomain() + "/api/sideline/agent/getProductList");
        httpRequest.charset(CharsetUtil.CHARSET_UTF_8);
        httpRequest.form(params);
        HttpResponse execute = null;
        try {
            execute = httpRequest.execute();
        } catch (Exception e) {
            log.error("工猫获取产品信息失败，请求体：{},error:", JSON.toJSONString(params), e);
            return null;
        }
        log.info("工猫获取产品信息，请求体：{},result:{}", JSON.toJSONString(params), execute.body());
        if (execute.isOk()) {
            return execute.body();
        } else {
            return null;
        }
    }


    private String getSign(Map<String, Object> params) {
        params.put("appKey", thirdPartyConfigProperties.getGongMaoAppKey());
        params.put("nonce", RandomUtil.randomString(32));
        params.put("timestamp", DateUtil.current());
        Set<String> keyList = params.keySet();
        List<String> list = new ArrayList<>(keyList);
        Collections.sort(list);

        StringBuilder sb = new StringBuilder();
        for (String key : list) {
            sb.append(key).append("=").append(params.get(key)).append("&");
        }
        sb.append("appSecret=").append(thirdPartyConfigProperties.getGongMaoAppSecret());
        System.out.println("sign未转MD5 = " + sb.toString());
        return MD5Util.standardMd5(sb.toString()).toUpperCase();
    }
}
