package com.bxm.thirdparty.platform.utils;

import com.google.i18n.phonenumbers.PhoneNumberToCarrierMapper;
import com.google.i18n.phonenumbers.Phonenumber;

import java.util.Locale;

/**
 * @author lowi
 * @date 2022/6/16 10:14
 */
public class PhoneUtil {


    private static PhoneNumberToCarrierMapper carrierMapper = PhoneNumberToCarrierMapper.getInstance();


    /**
     * 根据国家代码和手机号  判断手机运营商
     *
     * @param phoneNumber 手机号
     * @return
     */
    public static String getCarrier(String phoneNumber) {
        int ccode = Integer.parseInt("86");
        long phone = Long.parseLong(phoneNumber);
        Phonenumber.PhoneNumber pn = new Phonenumber.PhoneNumber();
        pn.setCountryCode(ccode);
        pn.setNationalNumber(phone);
        //返回结果只有英文，自己转成成中文
        String carrierEn = carrierMapper.getNameForNumber(pn, Locale.ENGLISH);
        String carrierZh = "";
        switch (carrierEn) {
            case "China Mobile":
                carrierZh = "移动";
                break;
            case "China Unicom":
                carrierZh = "联通";
                break;
            case "China Telecom":
                carrierZh = "电信";
                break;
            default:
                break;
        }
        return carrierZh;
    }
}
