package com.bxm.kylin._super.sdk;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * @author allen
 * @date 2021-08-23
 * @since 1.0
 */
public class CacheKey {

    private final String business;

    public CacheKey(String business) {
        this.business = business;
    }

    KeyGenerator hashDomains(String id) {
        return () -> KeyBuilder.build("kylin", business, "domain", String.valueOf(id));
    }

    KeyGenerator hashAvailableUrl() {
        return () -> KeyBuilder.build("kylin", business, "url");
    }

    KeyGenerator hashCheckPlan() {
        return () -> KeyBuilder.build("kylin", business, "check_plan");
    }
}
