package com.bxm.lovelink.cm;

import com.bxm.lovelink.cm.data.TableHandler;
import com.bxm.lovelink.cm.data.TableHandlerFactory;
import com.bxm.lovelink.cm.mq.CanalMessageListener;
import com.bxm.lovelink.cm.mq.CanalMqFetcher;
import com.bxm.warcar.mq.autoconfigure.rocketmq.RocketmqProperties;
import com.bxm.warcar.mq.rocketmq.RocketmqConsumer;
import com.google.common.collect.Lists;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;

/**
 * @author Allen Hu
 * @date 2025/7/2
 */
public class CmAutoConfiguration {

    @Bean
    public TableHandlerFactory tableHandlerFactory(ObjectProvider<Collection<TableHandler<?>>> tableHandlers) {
        Collection<TableHandler<?>> handlers = tableHandlers.getIfAvailable(Lists::newArrayList);
        return new TableHandlerFactory(handlers);
    }

    @Bean
    public CanalMessageListener canalMessageListener(ObjectProvider<CanalMqFetcher> canalMqFetcher, TableHandlerFactory tableHandlerFactory) {
        CanalMqFetcher fetcher = canalMqFetcher.getIfAvailable();
        if (Objects.isNull(fetcher)) {
            throw new BeanCreationException("使用Canal监听器，必须创建一个 CanalMqFetcher 接口实现类并注册到Spring。");
        }
        return new CanalMessageListener(fetcher, tableHandlerFactory);
    }

    @Bean(name = "cmCanalMessageConsumer", initMethod = "init", destroyMethod = "destroy")
    protected RocketmqConsumer cmCanalMessageConsumer(CanalMessageListener canalMessageListener, RocketmqProperties properties) {
        String nameSrvAddr = properties.getNameSrvAddr();
        String consumerId = canalMessageListener.getConsumerId();
        Map<String, String> brokerAddrAliasMap = properties.getBrokerAddrAliasMap();
        return new RocketmqConsumer(nameSrvAddr, canalMessageListener, consumerId, brokerAddrAliasMap);
    }
}
