package com.bxm.lovelink.cm.data;

import java.util.List;
import java.util.Set;

/**
 * 表处理接口。
 *
 * @param <T>
 */
public interface TableHandler<T> {

    /**
     * 表名
     * @return 如：user_basic_info
     */
    String ofTableName();

    /**
     * JSON序列化对象
     * @return 如：UserBasicInfo
     */
    Class<T> getDataClass();

    /**
     * 当触发插入时调用。请考虑幂等，因为当其他表处理接口实现发生异常，可能会重复调用这个方法。
     * @param data 插入的数据
     */
    void onInsert(List<T> data);

    /**
     * 当触发更新时调用。请考虑幂等，因为当其他表处理接口实现发生异常，可能会重复调用这个方法。
     * @param data 更新的数据
     * @param updateColumns 本次更新的字段
     */
    void onUpdate(List<T> data, List<Set<String>> updateColumns);

    /**
     * 当触发删除时调用。请考虑幂等，因为当其他表处理接口实现发生异常，可能会重复调用这个方法。
     * @param data 删除的数据
     */
    void onDelete(List<T> data);
}
