/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.cm.data;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import org.aspectj.lang.ProceedingJoinPoint;

public class SimpleMicrometerAspectTool
implements MeterBinder {
    private MeterRegistry meterRegistry;
    private final boolean timerEnabled = true;

    public void bindTo(MeterRegistry registry) {
        this.meterRegistry = registry;
    }

    public Object doMeter(ProceedingJoinPoint pjp) throws Throwable {
        if (null != this.meterRegistry) {
            String className = pjp.getTarget().getClass().getSimpleName();
            String methodName = pjp.getSignature().getName();
            Timer.Sample sample = null;
            sample = Timer.start((MeterRegistry)this.meterRegistry);
            try {
                Counter.builder((String)"service.execution.count").description("Count of service methods execution").tag("service", className).tag("method", methodName).register(this.meterRegistry).increment();
                Object object = pjp.proceed();
                return object;
            }
            catch (Throwable e) {
                Counter.builder((String)"service.execution.count.error").description("Count of service methods execution error").tag("service", className).tag("method", methodName).register(this.meterRegistry).increment();
                throw e;
            }
            finally {
                sample.stop(Timer.builder((String)"service.execution.time").description("Time spent on service methods").tag("service", className).tag("method", methodName).register(this.meterRegistry));
            }
        }
        return pjp.proceed();
    }
}

