/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.cm.data;

import com.alibaba.fastjson.JSONObject;
import com.bxm.lovelink.cm.data.Binlog;
import com.bxm.lovelink.cm.data.TableHandler;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(TableHandlerFactory.class);
    private final Map<String, TableHandler<?>> tableHandlerMap;

    public TableHandlerFactory(Collection<TableHandler<?>> tableHandlers) {
        this.tableHandlerMap = tableHandlers.stream().collect(Collectors.toMap(TableHandler::ofTableName, syncStrategy -> syncStrategy));
    }

    public void handle(Binlog binlog, String sourceBinLog) throws Exception {
        String table = binlog.getTable();
        TableHandler<?> tableHandler = this.tableHandlerMap.get(table);
        if (null == tableHandler) {
            return;
        }
        if (binlog.getIsDdl().booleanValue()) {
            log.info("IGNORE DDL: {}", (Object)sourceBinLog);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("SYNC: {}", (Object)sourceBinLog);
        }
        List<Map<String, Object>> data = binlog.getData();
        String jsonString = JSONObject.toJSONString(data);
        if (binlog.isDelete()) {
            Class<?> clazz = tableHandler.getDataClass();
            List dataList = JSONObject.parseArray((String)jsonString, clazz);
            tableHandler.onDelete(dataList);
        } else if (binlog.isUpdate()) {
            Class<?> clazz = tableHandler.getDataClass();
            List dataList = JSONObject.parseArray((String)jsonString, clazz);
            List<Map<String, Object>> old = binlog.getOld();
            List<Set<String>> updateColumns = old.stream().map(Map::keySet).collect(Collectors.toList());
            tableHandler.onUpdate(dataList, updateColumns);
        } else {
            Class<?> clazz = tableHandler.getDataClass();
            List dataList = JSONObject.parseArray((String)jsonString, clazz);
            tableHandler.onInsert(dataList);
        }
    }
}

