package com.bxm.mccms.facade.cache;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * <p>
 * 素材相关的缓存Key
 * </p>
 *
 * @author zhengwangeng
 * @since 2020/10/28 19:24
 */
public class CreativesKey {

    /**
     * 广告位素材
     * redis hash格式
     * key-> AD:CREATIVES
     * field->${素材id}
     * value
     */
    public static KeyGenerator creatives() {
        return () -> KeyBuilder.build("ADX", "CREATIVES");
    }

    /**
     * 标签关联的广告位素材
     * redis list 格式
     * key-> AD:CREATIVES:TAG:${tagCode}
     * value->${素材id}
     */
    public static KeyGenerator tagRelationCreative(String tagCode) {
        return () -> KeyBuilder.build("ADX", "CREATIVES", "TAG", tagCode);
    }
}
