package com.bxm.mccms.facade.enums;

/**
 * 广告位场景DSP <br/>
 *
 * @author zhengwangeng
 * @since 2020-8-13
 */
public class SceneDspEnum {

    /**
     * 素材来源：1是为手动上传，2为素材库素材
     */
    public enum CreativeSource {

        /** 手动上传 */
        MANUAL(1, "手动上传"),

        /** 素材库素材 */
        CREATIVE(2, "素材库素材"),
        ;

        /**
         * 值
         */
        private int type;

        /**
         * 描述
         */
        private String desc;

        CreativeSource(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }

        public static CreativeSource get(int type) {
            for (CreativeSource temp : CreativeSource.values()) {
                if (temp.type == type) {
                    return temp;
                }
            }
            return null;
        }
    }

    /**
     * 筛选类型：1标签筛选，2个性筛选
     */
    public enum ScreenType {

        /** 标签筛选 */
        TAG_SCREEN(1, "标签筛选"),

        /** 个性筛选 */
        PERSONALITY_SCREEN(2, "个性筛选"),
        ;

        /**
         * 值
         */
        private int type;

        /**
         * 描述
         */
        private String desc;

        ScreenType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }

        public static ScreenType get(int type) {
            for (ScreenType temp : ScreenType.values()) {
                if (temp.type == type) {
                    return temp;
                }
            }
            return null;
        }
    }
}
