package com.bxm.mccms.facade.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.mccms.facade.constant.Constants;

/**
 * <p>
 * 任务 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-3-25
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface ITaskFacadeService {

    /**
     * 修改任务状态
     * @param id
     * @param status
     * @param pauseReason
     * @return
     */
    @RequestMapping(value = "/facade/task/updateStatus", method = RequestMethod.GET, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> updateStatus(@RequestParam(value = "id", required = true) Long id,
                                               @RequestParam(value = "status", required = true) Integer status,
                                               @RequestParam(value = "pauseReason", required = false) Integer pauseReason);
}
