package com.bxm.mccms.facade.enums;

/**
 * 广告位场景DSP入口素材配置<br/>
 *
 * @author zhengwangeng
 * @since 2020-6-12
 */
public class SceneDspEntranceCreativeEnum {

    /**
     * 素材来源：1是为手动上传，2为素材库素材
     */
    public enum CreativeSource {

        /** 手动上传 */
        MANUAL(1, "手动上传"),
        /** 素材库素材 */
        CREATIVE(2, "素材库素材"),
        ;

        /**
         * 值
         */
        private int type;
        /**
         * 描述
         */
        private String desc;

        CreativeSource(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }
    }

}
