package com.bxm.mccms.facade.model.pushable;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.google.common.collect.Lists;

import lombok.Data;

/**
 * 广告位场景设置。</br>
 * Created by zhengwangeng on 2020/5/28 11:29.
 */
@Data
public class SceneSettingCacheVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 互动激励视频
     */
    public static final int SCENE_TYPE_INSPIRE_VIDEO = 1;
    /**
     * 变现百宝箱
     */
    public static final int SCENE_TYPE_BBX = 2;
    /**
     * 互动广告
     */
    public static final int SCENE_TYPE_INTERACT = 3;

    /**
     * 广告位Id
     */
    private String positionId;

    /**
     * 场景类型
     */
    private Integer sceneType;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动url
     */
    private String activityUrl;

    /**
     * 激励视频广告位
     */
    private String inspireVideoPositionId;

    /**
     * H5链接：互动广告和变现百宝箱，配置内容和互动广告相同，都需要配置该属性
     */
    private String h5Url;

    /**
     * 素材来源：1是为手动上传，2为素材库素材
     */
    private Integer creativeSource;

    /**
     * 广告标题（广告位约束），单个的。
     */
    private String creativeTitle;

    /**
     * 广告内容（广告位约束），多个按英文逗号分隔。允许空元素。如：title,title,,title
     */
    private String creativeContent;

    /**
     * 筛选类型：1标签筛选，2个性筛选
     */
    private Integer screenType;

    /**
     * 筛选值，多个用逗号分割
     */
    private String screenValue;

    /**
     * 活动
     */
    private List<SceneActivity> sceneActivities;

    /**
     * 媒体入口素材
     */
    private List<MediaEntranceCreative> mediaEntranceCreatives;

    @Data
    public static class SceneActivity implements Serializable {

        private static final long serialVersionUID = 1L;

        /**
         * 广告位ID
         */
        private String positionId;

        /**
         * 活动id
         */
        private String activityId;

        /**
         * 活动url
         */
        private String activityUrl;

        /**
         * 活动应用类型：1直接投放，2测试活动
         */
        private Integer type;

        /**
         * 有效期开始
         */
        private Date startDate;

        /**
         * 有效期结束
         */
        private Date endDate;

        /**
         * 流量分配占比
         */
        private Integer rateOfFlow;

        /**
         * 开关,1:开,0:关
         */
        private Integer opened;

    }

    @Data
    public static class MediaEntranceCreative implements Serializable {

        private static final long serialVersionUID = 1L;

        /**
         * 原生图文
         */
        public static final short POSITION_TYPE_NATIVE = 1;
        /**
         * 图片
         */
        public static final short POSITION_TYPE_PICTURE = 2;
        /**
         * 文字
         */
        public static final short POSITION_TYPE_TEXT = 3;
        /**
         * 视频
         */
        public static final short POSITION_TYPE_VIDEO = 4;

        /**
         * 素材ID
         */
        private Long creativeId;

        /**
         * 广告位ID
         */
        private String positionId;

        /**
         * 广告位类型
         */
        private Integer positionType;

        /**
         * 广告位类型的描述：多图文、单图文等
         */
        private String positionTypeDesc;

        /**
         * 素材名称
         */
        private String creativeName;

        /**
         * ICON（广告位约束），单个的。
         */
        private String creativeIcon;

        /**
         * 广告标题（广告位约束），单个的。
         */
        private String creativeTitle;

        /**
         * 广告内容（广告位约束），多个按英文逗号分隔。允许空元素。如：title,title,,title
         */
        private String creativeContent;

        /**
         * 广告图片（广告位约束），多个按英文逗号分隔。允许空元素。如：url,,url
         */
        private String creativePicture;

        /**
         * 广告封面图片（广告位约束），多个按英文逗号分隔。允许空元素。如：url,,url
         */
        private String creativeCover;

        /**
         * 广告视频（广告位约束），多个按英文逗号分隔。允许空元素。如：url,,url
         */
        private String creativeVideo;

        /**
         * 开关,1:开,0:关
         */
        private Integer opened;

        /**
         * 素材来源：1是为手动上传，2为素材库素材
         */
        private Integer creativeSource;

        /**
         * 标签：多个用逗号分割
         */
        private String tags;

        /**
         * 素材宽度
         */
        private Integer width;

        /**
         * 素材高度
         */
        private Integer height;

        public List<String> getCreativeContentList() {
            if(StringUtils.isBlank(this.getCreativeContent())){
                return null;
            }
            return Lists.newArrayList(StringUtils.splitPreserveAllTokens(this.getCreativeContent(), ","));
        }

        public List<String> getCreativePictures() {
            if(StringUtils.isBlank(this.getCreativePicture())){
                return null;
            }
            return Lists.newArrayList(StringUtils.splitPreserveAllTokens(this.getCreativePicture(), ","));
        }

        public List<String> getCreativeCoverList() {
            if(StringUtils.isBlank(this.getCreativeCover())){
                return null;
            }
            return Lists.newArrayList(StringUtils.splitPreserveAllTokens(this.getCreativeCover(), ","));
        }

        public List<String> getCreativeVideoList() {
            if(StringUtils.isBlank(this.getCreativeVideo())){
                return null;
            }
            return Lists.newArrayList(StringUtils.splitPreserveAllTokens(this.getCreativeVideo(), ","));
        }

        public boolean isOpen() {
            if (null == opened) {
                //由于字段是后来加的，并且素材list开始只支持配置一个，为了避免未初始化，默认null为素材开启状态
                return true;
            } else {
                if (1 == opened) {
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

}

