package com.bxm.mccms.facade.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.mccms.facade.constant.Constants;

/**
 * <p>
 * 流量分配 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-10-21
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface IPositionDspPosFacadeService {

    /**
     * SSP广告位同步到互动平台后，新增【激励视频DSP】流量分配
     * @param positionId
     * @param dspPosid
     * @return
     */
    @RequestMapping(value = "/facade/positionDspPos/addSspSyncInspireVideoDsp", method = RequestMethod.POST, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> addSspSyncInspireVideoDsp(@RequestParam(value = "positionId", required = true) String positionId,
                                                      @RequestParam(value = "dspPosid", required = true) String dspPosid
                                      );

    /**
     * SSP广告位同步到互动平台后，新增【图文DSP】流量分配
     * @param positionId
     * @param dspPosid
     * @return
     */
    @RequestMapping(value = "/facade/positionDspPos/addSspSyncVideotexDsp", method = RequestMethod.POST, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> addSspSyncVideotexDsp(@RequestParam(value = "positionId", required = true) String positionId,
                                                      @RequestParam(value = "dspPosid", required = true) String dspPosid
                                      );
}
