package com.bxm.mccms.facade.constant.pushable;

/**
 * 消息推送服务名<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/26 16:26
 */
public enum CachePushableServiceEnum {

	/** 全局配置 */
	CONFIG("CONFIG","CONFIG"),

	/** 开发者应用 */
	APP("APP","开发者应用"),
	/** 广告位 */
	POSITION("POSITION","广告位"),
	/** 创意 */
	CREATIVE("CREATIVE","创意"),
	/** 流量分发 */
	DISPATCHER("DISPATCHER","流量分发"),
	/** 流量分发-AB */
	DISPATCHERAB("DISPATCHERAB","流量分发"),
	/** DSP */
	DSP("DSP","DSP"),
	/** 广告位SDK配置 */
	POSITION_SDK_CONFIG("POSITION_SDK_CONFIG","广告位SDK配置"),
	/** 广告位屏蔽策略 */
	SHIELD_STRATEGY("SHIELD_STRATEGY","广告位屏蔽策略"),
	/** 广告位组件 */
	POSITION_ASSEMBLY("POSITION_ASSEMBLY","广告位组件"),
	/** 任务 */
	TASK("TASK","任务"),
	/** 广告位场景DSP设置 */
	SCENE_SETTING_CONFIG("SCENE_SETTING_CONFIG","广告位场景DSP设置"),
	/** 广告位与互动广告入口的映射关系配置 */
	POSITION_INTERACT_APPENTRANCE_REF("POSITION_INTERACT_APPENTRANCE_REF","广告位与互动广告入口的映射关系配置"),
	;

	/**
	 * 服务名
	 */
	private String name;
	/**
     * 描述
	 */
	private String desc;

	CachePushableServiceEnum(String name, String desc) {
		this.name = name;
		this.desc = desc;
	}

	public String getName() {
		return name;
	}

	public String getDesc() {
		return desc;
	}
}
