package com.bxm.mccms.facade.enums;

/**
 * 广告位场景DSP入口素材配置<br/>
 *
 * @author zhengwangeng
 * @since 2020-6-12
 */
public class SceneDspEntranceCreativeEnum {

    /**
     * 素材来源：1是为手动上传，2为素材库素材
     */
    public enum CreativeSource {

        /** 手动上传 */
        MANUAL(1, "手动上传"),
        /** 素材库素材 */
        CREATIVE(2, "素材库素材"),
        ;

        /**
         * 值
         */
        private int type;
        /**
         * 描述
         */
        private String desc;

        CreativeSource(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }
    }


    /**
     * 素材来源：1是为手动上传，2为素材库素材
     */
    public enum AnimationStyle {

        /** 无入场动画 */
        NONE(0, "无入场动画"),
        /** 横向动画-金蛋 */
        EGG(1, "横向动画-金蛋"),
        /** 横向动画-拉宝箱 */
        TREASURE_CHEST(2, "横向动画-拉宝箱"),
        /** 横向动画-跑路小人 */
        RUN_CHILD(3, "横向动画-跑路小人"),
        /** 纵向动画-掉红包 */
        DROP_RED_PACK(4, "纵向动画-掉红包"),
        /** 纵向动画-掉福袋 */
        DROP_LUCKY_BAG(5, "纵向动画-掉福袋"),
        /** 纵向动画-掉金币 */
        DROP_GOLD(6, "纵向动画-掉金币"),
        ;

        /**
         * 值
         */
        private int type;
        /**
         * 描述
         */
        private String desc;

        AnimationStyle(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }
    }

}
