package com.bxm.mccms.facade.model.activity;

import java.io.Serializable;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * <p>
 * 活动
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-8-27
 */
@Data
public class ActivityFacadeDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @NotNull(message = "ID不能为空！")
    private Integer activityId;

    /**
     * 旧链接
     */
    @NotBlank(message = "旧链接不能为空")
    private String oldActivityUrl;

    /**
     * 新链接
     */
    @NotBlank(message = "新链接不能为空")
    private String newActivityUrl;


}