package com.bxm.mccms.facade.model.pushable;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * <p>
 * 推送模型-流量分发(ab)
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-04-15
 */
@Data
public class DispatcherConfigCacheVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    private Long id;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 名称
     */
    private String name;

    /**
     * 用户分桶-开始
     */
    private Integer start;

    /**
     * 用户分桶-结束
     */
    private Integer end;

    /**
     * 配置下的DSP列表
     */
    private List<DispatcherDspCacheVO> dispatcherDspCaches;
}
