package com.bxm.mccms.facade.model.pushable;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 推送模型-广告位<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/27 13:47
 */
@Data
public class PositionCacheVO implements Serializable {

    private static final long serialVersionUID = 1L;
    
    /**
     * appid(Code)
     */
    private String appId;

    /**
     * 广告位
     */
    private String positionId;

    /**
     * 广告位类型：1 图文，2 图片，3 文字，4 视频
     */
    private Integer positionType;

    /**
     * 对接类型：1 API，2 SDK
     */
    private Integer dockingMethodType;

    /**
     * 广告位场景：由于有太多，还可能会增加，这里不再列举，请从ssp后台查看对应枚举
     */
    private Integer positionScene;

    /**
     * 信息流模板，这里不再列举，请从ssp后台查看对应枚举
     */
    private Integer informationFlowTemplate;

    /**
     * 平台类型：1 IOS，2 安卓，3 H5，4 PC
     */
    private Integer platformType;

    /**
     * 广告位尺寸：宽*高 大小
     */
    private String positionSize;

    /**
     * 合作类型： 1 分成，2 竞价，3 包段，4 UV
     */
    private Integer cooperationType;

    /**
     * 分成比例
     */
    private BigDecimal divideInto;

    /**
     * 竞价类型：1 CPM，2 CPC，3 CPA
     */
    private Integer biddingType;

    /**
     * 价格，合作类型为竞价时单位为 元/CPM，合作类型为包段时单位为 元/天，合作类型为UV时单位为 元/UV
     */
    private BigDecimal basePrice;

    /**
     * 包段开始时间
     */
    private LocalDate startDate;

    /**
     * 包段结束时间
     */
    private LocalDate endDate;

    /**
     * 媒体端广告位ID
     */
    private String appPositionId;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 屏蔽规则ID,多个用逗号分隔
     */
    private String shieldStrategyIds;

    /**
     * 是否已关闭：1 表示已关闭，0 表示未关闭
     */
    private Integer closedFlag;

    /**
     * 兜底策略：1无兜底，2组件兜底
     */
    private Integer fallbackStrategy;

    /**
     * 开屏时间，单位为秒
     */
    private Integer bootTime;

    /**
     * 显示结束页：0不显示，1显示
     */
    private Integer isShowEndpage;

    /**
     * 点击视频的行为：1视频暂停播放,2触发广告点击
     */
    private Integer clickVideoAction;

    /**
     * 显示广告角标：0不显示，1显示
     */
    private Integer isShowAdLogo;

    /**
     * 每天每人限推送次数
     */
    private Integer pushTimesPerPersonPerDay;

    /**
     * 推送展示停留时间，单位为秒
     */
    private Integer pushShowStayTime;

    /**
     * 推送间隔时间，单位为分钟
     */
    private Integer pushIntervalTime;

    /**
     * SDK初始化多少秒后开始推送
     */
    private Integer sdkInitIntervalTime;

    /**
     * 刷新间隔时间，单位为秒
     */
    private Integer refreshIntervalTime;

    /**
     * 刷新模式：1定时刷新，2点击刷新，多选用逗号分隔
     */
    private String refreshModel;

    /**
     * 广告时长：激励浏览时长，单位为秒
     */
    private Integer inspireShowTime;

    /**
     * 地域限制
     */
    private String region;

    /**
     * 自定义json配置，用于存储非标准数据，具体格式：PositionJsonConfig
     */
    private String jsonConfig;

    /**
     * 显示关闭按钮：0不显示，1显示
     */
    private Integer isShowCloseButton;

    /**
     * 显示活动关闭按钮：0不显示，1显示
     */
    private Integer isShowActivityCloseButton;

    /**
     * 显示跳过按钮时间，单位为秒
     */
    private Integer showSkipButton;

    /**
     * 开启预加载：0关闭，1开启
     */
    private Integer openPreloading;

    /**
     * API广告位拼接的参数
     */
    private String apiArgs;

    /**
     * 开启并行SDK配置：0关闭，1开启
     */
    private Integer isEnableParallelSdkConfig;

    /*************************************** 广告位不同类型的尺寸 ***************************************/
    /**
     * 封面图约束 {type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制'
     */
    private String coverPictureConstraints;

    /**
     * icon尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制
     */
    private String iconConstraints;

    /**
     * 大图尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制'
     */
    private String largeSizeConstraints;

    /**
     * 图片尺寸约束。{height-width-maximum_kb},{height-width-maximum_kb}。height：高，width：宽，maximum_kb：KB限制
     * 【这个是 图片 和 原生视频 共有的】
     */
    private String pictureConstraints;

    /**
     * 等待时长
     */
    private Integer waitTime;

    /**
     * 超时时长
     */
    private Integer overTime;
}
