package com.bxm.mccms.facade.enums;

/**
 * <p>
 * 任务暂停原因 枚举
 * 1-总曝光限制、2-日曝光限制、3-总点击限制、4-日点击限制、5-人工手动暂停
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-3-25
 */
public enum TaskPauseReasonEnum {

    VIEW_TOTAL_LIMIT(1, "总曝光限制"),
    VIEW_DAY_LIMIT(2, "日曝光限制"),
    CLICK_TOTAL_LIMIT(3, "总点击限制"),
    CLICK_DAY_LIMIT(4, "日点击限制"),
    MANUAL(5, "人工手动暂停"),
    ;

    private int value;
    private String name;

    TaskPauseReasonEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public static TaskPauseReasonEnum get(int value) {
        for (TaskPauseReasonEnum temp : TaskPauseReasonEnum.values()) {
            if (temp.value == value) {
                return temp;
            }
        }
        return null;
    }

}
