package com.bxm.mccms.facade.enums;

/**
 * <p>
 * 任务类型 枚举
 * 1- 曝光点击任务、2- 静默唤醒任务、3- 复制任务
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-3-25
 */
public enum TaskTypeEnum {

    VIEW_CLICK(1, "曝光点击任务"),
    SILENCE_WAKE(2, "静默唤醒任务"),
    /** 复制任务 */
    COPY(3, "复制任务"),
    ;

    private int value;
    private String name;

    TaskTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public static TaskTypeEnum get(int value) {
        for (TaskTypeEnum temp : TaskTypeEnum.values()) {
            if (temp.value == value) {
                return temp;
            }
        }
        return null;
    }

}
