package com.bxm.mccms.facade.model.pushable;

import java.io.Serializable;

import lombok.Data;

/**
 * <p>
 * 推送模型-应用游戏模板
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-12-24
 */
@Data
public class AppGameTemplateCacheVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 代号
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 周期
     */
    private Integer cycle;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 具体配置Json
     */
    private String jsonConfig;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 审核状态：0-待审核，1-审核通过，2-审核拒绝
     */
    private Integer auditStatus;

}
