package com.bxm.mccms.facade.model.reviewrefuseconfig;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * <p>
 * 审核维护配置
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
@Data
public class ReviewRefuseConfigFacadeDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 审核环节：1 财务，2 应用，3 广告位
     */
    private Integer sector;

    /**
     * 拒绝理由
     */
    private String refuseReason;

    /**
     * 操作提示建议
     */
    private String advise;

    /**
     * 前端展示理由
     */
    private String showReason;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 是否逻辑删除：1 表示删除，0 表示未删除
     */
    private Integer deleted;

    /**
     * 分页
     */
    private Integer current;
    private Integer size;


}