package com.bxm.mccms.facade.service;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.mccms.facade.constant.Constants;
import com.bxm.mccms.facade.model.sysdict.SysDictFacadeVO;

/**
 * <p>
 * 系统字典 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-20
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface ISysDictFacadeService {

    /**
     * 根据参数查询列表信息
     * @param typeCode
     * @param parentDictValue
     * @return
     */
    @RequestMapping(value = "/facade/sysdict/list", method = RequestMethod.GET, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<SysDictFacadeVO>> list(@RequestParam(value = "typeCode", required = false) String typeCode,
                                               @RequestParam(value = "parentDictValue", required = false) String parentDictValue);
}
