package com.bxm.mcssp.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * Description 流帮助类
 *
 * <p>
 * Date 2019/1/17 14:42
 */
public final class InputStreamUtil {


    /**
     * copy 一份 流
     * Create Date：2019/1/17 14:44
     *
     * @param inputStream 流
     * @return java.io.InputStream
     */
    public static InputStream copy(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len;
        while ((len = inputStream.read(buffer)) > -1) {
            byteArrayOutputStream.write(buffer, 0, len);
        }
        byteArrayOutputStream.flush();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }


}
