package com.bxm.mcssp.common.entity;

import java.io.Serializable;

import lombok.Data;

/**
 * <p>
 * 广告位的动态相关配置
 * 由于广告位不同场景的配置差异很大，且有越来越多的情况，所以使用json存储，这里定义json格式
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-01-05
 */
@Data
public class PositionJsonConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * position_scene=PositionSceneTypeEnum.PUSH
     */
    private Push push;

    /**
     * position_scene=PositionSceneTypeEnum.LOCK_SCREEN
     */
    private LockScreen lockScreen;

    @Data
    public static class Common {

        /**
         * 进程名称
         */
        private String processName;

        /**
         * 进程图标
         */
        private String processIcon;

    }

    @Data
    public static class Push extends Common {

    }

    @Data
    public static class LockScreen extends Common {

        /**
         * 广告样式
         * 1:双浮标+资讯/视频  1080*1920px
         */
        private Integer adStyle;

        /**
         * 浮标1广告位ID
         */
        private String iconPositionId1;

        /**
         * 浮标2广告位ID
         */
        private String iconPositionId2;

        /**
         * 资讯/视频URL
         */
        private String url;


        /**
         * 每人每天限出现:次
         */
        private Integer showTimesPerPersonPerDay;

        /**
         * 息屏后延迟触发时间:秒
         */
        private Integer intervalTriggerTime;

        /**
         * 沉默期（单位：小时）
         */
        private Integer silentPeriod;
        /**
         * 用户锁屏设置（0关1开）
         */
        private Integer userLockSetup;
    }


}
