/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mcssp.common.util;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.bitwalker.useragentutils.Browser;
import nl.bitwalker.useragentutils.OperatingSystem;
import nl.bitwalker.useragentutils.UserAgent;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtil {
    private static final Logger log = LoggerFactory.getLogger(WebUtil.class);
    private static final String ECODING = "UTF-8";

    public static String getHTML(String url) throws Exception {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        URL uri = new URL(url);
        URLConnection connection = uri.openConnection();
        InputStream in = connection.getInputStream();
        byte[] buf = new byte[1024];
        int length = 0;
        StringBuffer sb = new StringBuffer();
        while ((length = in.read(buf, 0, buf.length)) > 0) {
            sb.append(new String(buf, ECODING));
        }
        in.close();
        return sb.toString();
    }

    public static String getUserAgent(HttpServletRequest request) {
        try {
            String userAgentStr = request.getHeader("User-Agent");
            UserAgent userAgent = UserAgent.parseUserAgentString((String)userAgentStr);
            Browser browser = userAgent.getBrowser();
            OperatingSystem os = userAgent.getOperatingSystem();
            String browserInfo = os.getDeviceType() + "," + os.getName() + "," + browser.getName();
            return browserInfo;
        }
        catch (Exception e) {
            System.out.println("e.getMessage()------>" + e.getMessage());
            log.error(e.getMessage());
            e.printStackTrace();
            return "unknown";
        }
    }

    public static String getIpAddr(HttpServletRequest request) {
        try {
            String ip = request.getHeader("x-forwarded-for");
            log.debug("[*] get request ip from x-forwarded-for:{}", (Object)ip);
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
                log.debug("[*] get request ip from Proxy-Client-IP:{}", (Object)ip);
            }
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
                log.debug("[*] get request ip from WL-Proxy-Client-IP:{}", (Object)ip);
            }
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
                log.debug("[*] get request ip from remoteAddr:{}", (Object)ip);
            }
            log.debug("[x] the final ip is:{}", (Object)ip);
            return ip;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            return "unknown";
        }
    }

    public static String getContextPath(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(request.getContextPath());
        String path = sb.toString();
        return path;
    }

    public static String getRequestURIWithParam(HttpServletRequest request) {
        return request.getRequestURI() + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
    }

    public static Map<String, String> getParamMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration enume = request.getParameterNames();
        while (enume.hasMoreElements()) {
            String name = (String)enume.nextElement();
            map.put(name, request.getParameter(name));
        }
        return map;
    }

    public static void addCookie(HttpServletResponse response, String domain, String path, boolean isHttpOnly, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        if (null != domain && !domain.isEmpty()) {
            cookie.setDomain(domain);
        }
        cookie.setPath("/");
        if (null != path && !path.isEmpty()) {
            cookie.setPath(path);
        }
        cookie.setHttpOnly(isHttpOnly);
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        response.addCookie(cookie);
    }

    public static String HtmltoText(String inputString) {
        String htmlStr = inputString;
        String textStr = "";
        try {
            String regEx_script = "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
            String regEx_style = "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>";
            String regEx_html = "<[^>]+>";
            String patternStr = "\\s+";
            Pattern p_script = Pattern.compile(regEx_script, 2);
            Matcher m_script = p_script.matcher(htmlStr);
            htmlStr = m_script.replaceAll("");
            Pattern p_style = Pattern.compile(regEx_style, 2);
            Matcher m_style = p_style.matcher(htmlStr);
            htmlStr = m_style.replaceAll("");
            Pattern p_html = Pattern.compile(regEx_html, 2);
            Matcher m_html = p_html.matcher(htmlStr);
            htmlStr = m_html.replaceAll("");
            Pattern p_ba = Pattern.compile(patternStr, 2);
            Matcher m_ba = p_ba.matcher(htmlStr);
            textStr = htmlStr = m_ba.replaceAll("");
        }
        catch (Exception e) {
            System.err.println("Html2Text: " + e.getMessage());
        }
        return textStr;
    }

    public static String getHTMLToString(String sourcestr) {
        if (sourcestr == null) {
            return "";
        }
        sourcestr = sourcestr.replaceAll("\\x26", "&amp;");
        sourcestr = sourcestr.replaceAll("\\x3c", "&lt;");
        sourcestr = sourcestr.replaceAll("\\x3e", "&gt;");
        sourcestr = sourcestr.replaceAll("\\x09", "&nbsp;&nbsp;&nbsp;&nbsp;");
        sourcestr = sourcestr.replaceAll("\\x20", "&nbsp;");
        sourcestr = sourcestr.replaceAll("\\x22", "&quot;");
        sourcestr = sourcestr.replaceAll("\r\n", "<br>");
        sourcestr = sourcestr.replaceAll("\r", "<br>");
        sourcestr = sourcestr.replaceAll("\n", "<br>");
        return sourcestr;
    }

    public static String getStringToHTML(String sourcestr) {
        if (sourcestr == null) {
            return "";
        }
        sourcestr = sourcestr.replaceAll("&amp;", "\\x26");
        sourcestr = sourcestr.replaceAll("&lt;", "\\x3c");
        sourcestr = sourcestr.replaceAll("&gt;", "\\x3e");
        sourcestr = sourcestr.replaceAll("&nbsp;&nbsp;&nbsp;&nbsp;", "\\x09");
        sourcestr = sourcestr.replaceAll("&nbsp;", "\\x20");
        sourcestr = sourcestr.replaceAll("&quot;", "\\x22");
        sourcestr = sourcestr.replaceAll("<br>", "\r\n");
        sourcestr = sourcestr.replaceAll("<br>", "\r");
        sourcestr = sourcestr.replaceAll("<br>", "\n");
        return sourcestr;
    }
}

